const express = require('express');
const router = express.Router();
const { exportRegistrations } = require('../controllers/exportController');
const { authenticateToken, authorizeRole } = require('../middleware/authMiddleware');

// Only admins should be able to export data
router.get('/registrations', authenticateToken, authorizeRole(['admin']), exportRegistrations);

module.exports = router;
