const { pool } = require('../config/db');

const addPartnerRole = async () => {
  const client = await pool.connect();
  try {
    await client.query('BEGIN');

    // Add 'partner' role if it doesn't exist
    await client.query(`
      INSERT INTO roles (name)
      VALUES ('partner')
      ON CONFLICT (name) DO NOTHING;
    `);

    console.log("Role 'partner' added successfully");
    await client.query('COMMIT');
  } catch (e) {
    await client.query('ROLLBACK');
    console.error('Error adding partner role', e);
  } finally {
    client.release();
    process.exit();
  }
};

addPartnerRole();
